
<?php get_header(); ?>
<div id="content">

<?php if (have_posts()) : ?>
	<div class="pagetitle">
		<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
		<?php /* If this is a category archive */ if (is_category()) { ?>
		<h2>Archive for the &#8216; <?php single_cat_title(); ?> &#8217; Category</h2>
		<?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
		<h2>Posts Tagged &#8216; <?php single_tag_title(); ?> &#8217;</h2>
		<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h2>Archive for <?php the_time('F jS, Y'); ?></h2>
		<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h2>Archive for <?php the_time('F, Y'); ?></h2>
		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h2>Archive for <?php the_time('Y'); ?></h2>
		<?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h2>Author Archive</h2>
		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2>Blog Archives</h2><?php } ?>

	</div>

	<?php while (have_posts()) : the_post(); ?>

	<div class="post" id="post-<?php the_ID(); ?>">
		<div class="title">
			<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
			<p>
				<span><?php the_time('F j, Y g:i a') ?></span>
				<span>| </span>
				<span class="group2"><?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?></span>
			</p>
		</div>
		<div class="entry">
			<?php the_content('[More]'); ?>
		</div>
	</div>

	<?php endwhile; ?>
	
	<div class="navigation">
		<div class="prev">
			<?php next_posts_link('Previous Entries') ?>
		</div>
		<div class="next">
			<?php previous_posts_link('Next Entries') ?>
		</div>
	</div>

<?php else : ?>
	<div class="pagetitle">
		<h2>No Archive Found</h2>
	</div>
	<div class="errormsg">
		<p>Sorry, but you are looking for an archive that isn't here.</p>
	</div>
<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
